<?php
header('Content-Type: application/json');

// Database connection
$host = 'localhost:3306';
$dbname = 'tawasoll_book';
$username = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    exit;
}

if (!isset($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'No transaction ID provided']);
    exit;
}

$id = $_GET['id'];

try {
    $pdo->beginTransaction();
    
    // Get transaction details before deleting
    $stmt = $pdo->prepare("SELECT * FROM transactions WHERE id = :id");
    $stmt->execute([':id' => $id]);
    $transaction = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$transaction) {
        throw new Exception('Transaction not found');
    }
    
    $customer_phone = $transaction['customer_phone'];
    $transaction_type = $transaction['transaction_type'];
    $aed_amount = $transaction['aed_amount'];
    
    // Delete the transaction
    $delete_stmt = $pdo->prepare("DELETE FROM transactions WHERE id = :id");
    $delete_stmt->execute([':id' => $id]);
    
    // Update customer balance - reverse the transaction
    if ($transaction_type == 'CREDIT') {
        // If it was a credit, subtract from balance
        $update_balance = "UPDATE customer_context 
                          SET current_balance = current_balance - :amount,
                              total_credits = total_credits - :amount,
                              transaction_count = transaction_count - 1
                          WHERE customer_phone = :phone";
    } else {
        // If it was a debit, add to balance
        $update_balance = "UPDATE customer_context 
                          SET current_balance = current_balance + :amount,
                              total_debits = total_debits - :amount,
                              transaction_count = transaction_count - 1
                          WHERE customer_phone = :phone";
    }
    
    $balance_stmt = $pdo->prepare($update_balance);
    $balance_stmt->execute([
        ':amount' => $aed_amount,
        ':phone' => $customer_phone
    ]);
    
    $pdo->commit();
    
    echo json_encode(['success' => true, 'message' => 'Transaction deleted successfully']);
    
} catch(Exception $e) {
    $pdo->rollBack();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
